import numpy as np
import scipy.signal as sig

def create_time_data(num, samp_freq):
    
    delta_t = 1./samp_freq
    start, stop = 0, (num-1)*delta_t

    t = np.linspace(start, stop, num)

    return t


def create_waveform_data(t, a, f, shape):

    num = len(t)

    if shape == 'Sine':
        y = a*np.sin(2*np.pi*f*t)
    elif shape == 'Cosine':
        y = a*np.cos(2*np.pi*f*t)
    elif shape == 'DC Level':
        y = a*np.ones(num)
    elif shape == 'Square':
        y = a*sig.square(2*np.pi*f*t)
    elif shape == 'Sawtooth':
        y = a*sig.sawtooth(2*np.pi*f*t, 1.0)
    elif shape == 'Triangle':
        y = a*sig.sawtooth(2*np.pi*f*t, 0.5)
    elif shape == 'User-Defined':
        y = (5*np.sin(2*np.pi*50*t)
             + 5*np.sin(2*np.pi*100*t))

    return y



if __name__ == '__main__':

    import matplotlib.pyplot as plt

    num, samp_freq = 100, 100
    a, f = 5, 3
    shape = 'Sine'
    
    t = create_time_data(num, samp_freq)
    y = create_waveform_data(t, a, f, shape)
    
    plt.plot(t, y)
    plt.show()
